function sys_state = Partial_Closed_sys(t,xx, A, B, C, D1, D2, F, K, N_p, J_p, L_p, H_p)
X = xx(1:3);
Z = xx(4:8);

global Intp_ts Intp_count Intp_tmp
global Intp_hatf1 Intp_hatx1 Intp_hatx2 Intp_hatx3 Intp_f1 

f = 0.5 + 1 * sin(2.5*pi*t); % fault
da = 0.5 * cos(2.5*t) + cos(2*t)*0.2*sin(X(1))*cos(X(2)); % actuator attack
ds = cos(pi*t);  % sensor attack
d = [ds;da];

% controller
u = -K*X;

%%%Observer
% estimates of state, fault, perturbations
y = C*X + D2*d;
hat_x = Z + H_p*y;

hat_X = hat_x(1:3);
hat_f = hat_x(5);

dot_Z = N_p*Z + J_p*u + L_p*y;

% sys dynamic
dot_X = A*X + B*u + F*f + D1*d;

% % data saving 
if mod(Intp_tmp,2)==0
    Intp_count = Intp_count + 1;
Intp_ts(Intp_count) = t;
Intp_f1(Intp_count) = f;
Intp_hatf1(Intp_count) = f - hat_f;
Intp_hatx1(Intp_count) = X(1) - hat_X(1);
Intp_hatx2(Intp_count) = X(2) - hat_X(2);
Intp_hatx3(Intp_count) = X(3) - hat_X(3);
end
Intp_tmp = Intp_tmp + 1;

sys_state = [dot_X; dot_Z];